﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace UHFDemo
{
    public partial class LabelTrackBar : UserControl
    {
        private int Flag;

        public int TickValue
        {
            get
            {
                return trackBar.Value;
            }
            set
            {
                if (Flag == 0)
                {
                    value = value > 19 ? 19 : value;
                    trackBar.Value = value;
                    label.Text = string.Format("{0}dbm", trackBar.Value);
                }
                else
                {
                    value = value > 172 ? 172 : value;
                    trackBar.Value = value;
                    label.Text = string.Format("-{0}dbm", trackBar.Value);
                }
            }
        }

        public LabelTrackBar(int Flag)
        {
            InitializeComponent();
            this.Flag = Flag;

            if (Flag == 0)
            {
                trackBar.Minimum = 0;
                trackBar.Maximum = 19;
                trackBar.TickFrequency = 3;
                trackBar.SmallChange = 1;
                trackBar.LargeChange = 3;
                trackBar.Value = 19;
                label.Text = string.Format("{0}dbm", trackBar.Value);
            }
            else
            {
                trackBar.Minimum = 0;
                trackBar.Maximum = 172;
                trackBar.TickFrequency = 20;
                trackBar.SmallChange = 2;
                trackBar.LargeChange = 20;
                trackBar.Value = 172;
                label.Text = string.Format("-{0}dbm", trackBar.Value);
            }
        }

        public delegate void ScrollHandler(object sender);
        public event ScrollHandler OnTractBar_MouseUp;

        private void trackBar_Scroll(object sender, EventArgs e)
        {
            if (Flag == 0)
            {
                label.Text = string.Format("{0}dbm", trackBar.Value);
            }
            else
            {
                label.Text = string.Format("-{0}dbm", trackBar.Value);
            }
        }

        private void trackBar_MouseUp(object sender, MouseEventArgs e)
        {
            if (OnTractBar_MouseUp != null)
            {
                OnTractBar_MouseUp(this);
            }
        }
    }
}
